<?php
/* vi: ts=2 sw=2 et nu
 * This file implements b2SlideShow plugin for b2evolution
 *
 * b2SlideShow allows sequential display (slide show) of 
 * the image content of a subdirectory in the media/blogs directory
 *
 * b2evolution - {@link http://b2evolution.net/}
 * Released under GNU GPL License - {@link http://b2evolution.net/about/license.html}
 * @copyright (c)2003-2007 by Francois PLANQUE - {@link http://fplanque.net/}
 * 2012, 2013 Jacques LOUVEL (jl95870)
 * 
 * @package plugins
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

/**
 * @package plugins
 */
class b2slideshow_plugin extends Plugin
{
	var $code = 'b2SlideShow';
	var $name ;
	var $priority = 14;
	var $version = '2.3';
	var $apply_rendering = 'opt-out';
	var $group = 'rendering';
	var $short_desc;
	var $long_desc;
	var $number_of_installs = 1;
	var $help_url = 'http://www.le-fataliste.fr/blabla/atelier/jl-diarama';

	/*
	 * Internal
	 */
	var $post_search_list;
	var $post_replace_list;
	var $comment_search_list;
	var $comment_replace_list;
	//
	var $jltmp_lang;
	var $jltmp_s;
	var $jltmp_w;
	var $jltmp_id;

	/**
	 * Init
	 */
	function PluginInit( & $params )
	{
		$this->name = $this->T_('Slide show Links') ;
		$this->short_desc = $this->T_('Slide show Links e-g {{en:15:620:Photoblog/subDir}}');
		$this->long_desc = $this->T_('Creates html to display images found in the given subDir, in the specified Photoblog directory');
	}

	/**
	 * Get the default settings of the plugin.
	 *
	 * @return array
	 */
	function GetDefaultSettings()
	{
		return array( /*'render_comments' => array(
		'label' => $this->T_('Render comments'),
		'note' => $this->T_( 'If enabled, links will be produced in comments also' ),
		'defaultvalue' => 0, 
		'type' => 'checkbox'
		) */) ;
	}

	/**
	 * Perform rendering
	 *
	 * @see Plugin::RenderItemAsHtml()
	 */
	function RenderItemAsHtml( & $params )
	{
		global $jltmp_lang;
		global $jltmp_s;
		global $jltmp_w;
		global $jltmp_id;
		
		$content = & $params['data'];
		$bidon = preg_match('#\{\{([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([0-9A-Za-z]+)/([0-9A-Za-z_;\&\=\.\/\-]+)\}\}#i',$content,$matches);
		if( ! $bidon ){
			$bidon = preg_match('#\{\{([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([0-9A-Za-z_;\&\=\.\/\-]+)\}\}#i',$content,$matches);
		}
		if($bidon) {
			$jltmp_path = dirname(__FILE__);
			$jltmp_lang = $matches[1];
			$jltmp_s = $matches[2];
			$jltmp_w = $matches[3];
			$jltmp_id = $matches[4];
			if(isset($matches[5])){$jltmp_id.='/'.$matches[5];};
			$jltmp_id = trim(str_replace("&amp;","&",$jltmp_id));
			//
			$onYva = false;
			$jl_diarama_plugin_chemin = dirname(__FILE__);
			$diarama_lang = strtolower(trim($jltmp_lang));
			// we get the language parameter
			if($diarama_lang == ''){$diarama_lang = 'fr';};
			// we get the interval between frames
			$diarama_interval = intval($jltmp_s);
			$diarama_auto = 1;
			// we get the speed parameter (i.e. the slide interval)
			if($diarama_interval == 0){$diarama_auto = 0;};
			// we get the image width
			$diarama_width = intval($jltmp_w);
			if(in_array($diarama_width,array(450,620,720,800,1024)))
			{
				$diarama_tailleImage = array_search($diarama_width,array(1 => 450, 2 => 620, 3 => 720, 4 => 800, 5 => 1024));
			}
			else
			{
				$diarama_tailleImage = 6;
			};
			//
			$t_fileTypes = array('jpg','jpeg','png','gif','tif','tiff');
			$diarama_aideIni = 0; // 0 or 1 = display help at start w time suspension
			$diarama_rapportImage = 0.675; // image width/height ratio = 4/3
			$diarama_forceRatio = 0;
			$diarama_modeImage = 1; // Image mode => 0=only one image changing with tome / 1=undetermined images number
			$diarama_circulaire = 0; // Diarama mode => 0=we shall stop at the last image  (default) / n>0=we shall circle n times
			$diarama_premiere = 0; // # of first Image 
			$diarama_derniere = -1; // # of last Image : -1= not yet known
			$diarama_ordre = 2; // 2= do nothing i.e. date of the file (default) / 0=random / 1=alphanum order / -1=inverse / -2=alphanum inverse
			$diarama_liste = ''; // Images list file name
			$diarama_position = 1; // images position 0=head / 1=in post body
			$diarama_cmt = 0; // number of comments associated to image files
			$lesMsg = '';
			$lesCmt = '';
			// we get the additional parameters after the directory (&...) in $jltmp_id !!!
			if($jltmp_id != '')
			{
				//
				$jltmp_params = explode('&',$jltmp_id);
				$jltmp_id = $jltmp_params[0];
				if(count($jltmp_params) >1)
				{
					for($i = 1;$i < count($jltmp_params); $i++)
					{
						$jltmp_ppar = explode('=', $jltmp_params[$i]);
						switch($jltmp_ppar[0])
						{
							case 'h':
								// we shall display help at start if =1 (the timer ill be suspended)
								$diarama_aideIni = trim($jltmp_ppar[1]);
								if( $diarama_aideIni != 0) 
								{
									$diarama_aideIni = 1;
								};
								break;
							case 'e':
								// we get the allowed file extensions (coma separated)
								$diarama_fileTypes = trim($jltmp_ppar[1]);
								$temp_fileTypes = explode(",",$diarama_fileTypes);
								for($j=0;$j<count($temp_fileTypes);$j++)
								{
									if(in_array($temp_fileTypes[$j],array('jpg','jpeg','png','gif','tif','tiff')))
									{
										$t_fileTypes[] = $temp_fileTypes[$j];
									};
								};
								if(count($t_fileTypes) == 0)
								{
									$t_fileTypes = array('jpg','jpeg','png','gif','tif','tiff');
								};
								break;
							case 'r':
								// image width/height ratio
								$diarama_rapportImage = trim($jltmp_ppar[1]);
								$diarama_forceRatio = 1;
								if(($diarama_rapportImage<=0) OR ($diarama_rapportImage>2.5))
								{
									$diarama_rapportImage = 0.675;
									$diarama_forceRatio = 0;
								};
								break;
							case 'm':
								// Image mode => 0=only one image changing with tome / 1=undetermined images number
								$diarama_modeImage = trim($jltmp_ppar[1]);
								if(($diarama_modeImage != 0) AND ($diarama_modeImage != 1))
								{
									$diarama_modeImage = "1";
								};
								break;
							case 'c':
								// Diarama mode => 0=we shall stop at the last image  (default) / n>0=we shall circle n times
								$diarama_circulaire = trim($jltmp_ppar[1]);
								if( !is_numeric($diarama_circulaire) OR ($diarama_circulaire < 0) OR ($diarama_circulaire > 100) )
								{
									$diarama_circulaire = 1;
								};
								break;
							case 'p':
								// this is the # of the first Image 
								$diarama_premiere = trim($jltmp_ppar[1]);
								break;
							case 'd':
								// this is the # of the last Image 
								$diarama_derniere = trim($jltmp_ppar[1]);
								break;
							case 'o':
								// order the images  presentation according to their name
								// 2= do nothing i.e. date of the file (default) / 0=random / 1=alphanum order / -1=inverse / -2=alphanum inverse
								$diarama_ordre = trim($jltmp_ppar[1]);
								break;
							case 'l': 
								// image list file (text file)
								$diarama_liste = trim($jltmp_ppar[1]);
								break;
							case 't':
								// Image position => 0=at the head of the post body (linked image, default) / 1=in the post body
								$diarama_position = trim($jltmp_ppar[1]);
								break;
							default:
								break;
						};
					};
				};
			};
			//
			if($jltmp_id != '')
			{
				// we get the images path parameter
				$diarama_chemin = $jltmp_id;
				$lesDossiers = explode("/",$diarama_chemin);
				if( count($lesDossiers) == 1)
				{
					$lesDossiers[1] = trim($lesDossiers[0]);
					$lesDossiers[0] = '';
				};
				if( trim($lesDossiers[0]) == '')
				{
					$lesDossiers[0] = 'Photoblog';
				};
				if( trim($lesDossiers[1]) == '')
				{
					$lesDossiers[1] = 'diarama';
				};
				$leDossier = '';
				for($i=0;$i<count($lesDossiers);$i++)
				{
					if(trim($lesDossiers[$i]) != '')
					{
						if($leDossier != ''){ $leDossier.='/';};
						$leDossier .= $lesDossiers[$i];
					};
				};
				$jltmp_dir = dirname(__FILE__);
				$jltmp_dir_tab = explode('/plugins/',$jltmp_dir);
				$diarama_leDir = '../../media/blogs/'.$leDossier;
				$diarama_host_leDir = $jltmp_dir_tab[0].'/media/blogs/'.$leDossier;
				$jl95870cam_prems = "";
				$filelist = '';
				$fileCpt = -1;
				if($diarama_liste != '')
				{
					$ext = substr(strtolower(strrchr(basename($diarama_liste), ".")), 1);
					if( $ext == 'txt' )
					{
						$diarama_laListe = $diarama_host_leDir.'/'.$diarama_liste;
						if(file_exists($diarama_laListe))
						{
							$filelist_tab = file($diarama_laListe, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
							$filecomt_tab = '';
							for($i=0; $i<count($filelist_tab); $i++)
							{
								$file = trim($filelist_tab[$i]);
								// on rcupre le nom de fichier image et son commentaire ventuel (aprs un point-vrigule)
								$file_tab = explode(";",$file);
								$file = $file_tab[0];
								if(count($file_tab) > 1)
								{
									$filecomt = strip_tags(trim($file_tab[1]),'<i><u><b><font>');
								}
								else
								{
									$filecomt = '';
								};
								if(is_file($diarama_host_leDir.'/'.$file))
								{
									$ext = substr(strtolower(strrchr(basename($file), ".")), 1);
									if(in_array($ext,$t_fileTypes))
									{
										if($filelist != '')
										{ 
											$filelist .= ', ';
										}
										else
										{
											$jl95870cam_prems = $diarama_leDir.'/'.$file;
											// on ne modifiera pas l'ordre mme si le code dit le contraire
											$diarama_ordre = 2;
										};
										$filelist .= "'".$file."'";
										$filecomt_tab[] = $filecomt;
										if($filecomt != '')
										{
											$diarama_cmt ++;
										};
										$onYva = true;
										$fileCpt ++;
									};
								};
							};
						};
					};
				}
				else
				{
					if ($dir = opendir($diarama_host_leDir)) 
					{
						while (($file = readdir($dir)) !== false) 
						{
							if(is_file($diarama_host_leDir.'/'.$file))
							{
								$ext = substr(strtolower(strrchr(basename($file), ".")), 1);
								if(in_array($ext,$t_fileTypes))
								{
									if($filelist != '')
									{ 
										$filelist .= ', ';
									}
									else
									{
										$jl95870cam_prems = $diarama_leDir.'/'.$file;
									};
									$filelist .= "'".$file."'";
									$filecomt_tab[] = '';
									$onYva = true;
									$fileCpt ++;
								};
							};
						}; 
						closedir($dir);
					};
				};
			};
			if(! $onYva) 
			{
				//s'il n'y a pas d'image dans le dossier
				if($diarama_liste != '')
				{
					$annonce = 'Aucun fichier image valide dans le fichier '.$diarama_liste.'\nou ce fichier n\'existe pas dans le dossier images\n\nNo valid image file in the file '.$diarama_liste.'\nor this file was not found in the specified dir.';
					$lesMsg = 'Aucun fichier image valide dans le fichier '.$diarama_liste.'<br />ou ce fichier n\'existe pas dans le dossier images<br /><br />No valid image file in the file '.$diarama_liste.'<br />or this file was not found in the specified dir.';
				}
				else
				{
					$annonce = 'Aucun fichier image valide dans le dossier '.$diarama_leDir.'\nNo valid image file in the directory '.$diarama_leDir;
					$lesMsg = 'Aucun fichier image dans le dossier '.$diarama_leDir.'<br />No image file in the directory '.$diarama_leDir;
				};
			}
			else
			{
				if(($diarama_premiere <= 0) OR ($diarama_premiere > $fileCpt))
				{
					$diarama_premiere = 0;
				};
				if(($diarama_derniere < $diarama_premiere) OR ($diarama_derniere > $fileCpt))
				{
					$diarama_derniere = $fileCpt;
				};
				// classement alpha des noms de fichiers
				// 2=sans changement / 0=hasard / 1=ordre alpha / -1=inverse / -2=alpha inverse
				if( ($diarama_ordre == 0) OR ($diarama_ordre == 1) OR ($diarama_ordre == -1) OR ($diarama_ordre == -2) )
				{
					$temp_fileList = explode(",",$filelist);
					if($diarama_ordre == 0)
					{
						shuffle($temp_fileList);
					};
					if( $diarama_ordre == 1 )
					{
						natcasesort($temp_fileList);
					};
					if( $diarama_ordre == -2 )
					{
						rsort($temp_fileList);
					};
					if( $diarama_ordre == -1 )
					{
						$temp_fileList = array_reverse($temp_fileList);
					};
					$filelist = '';
					$filelist = implode(',',$temp_fileList);
					/*
					for($i=0;$i<count($temp_fileList);$i++)
					{
						if($filelist != ''){ $filelist .= ', ';};
						$filelist .= $temp_fileList[$i];
					};
					*/
					$jl95870cam_prems = $diarama_leDir.'/'.$temp_fileList[0];
				};
				// cration du tableau js des commentaires (vide si pas de comt)
				$lesCmt = 'var jl95870cam_listeCmt=new Array();';
				for($i = 0;$i < count($filecomt_tab);$i++)
				{
					$lesCmt .= "\n".'jl95870cam_listeCmt['.$i.']="'.$filecomt_tab[$i].'";';
				};
				//
				$diarama_leDir .= '/';
				$annonce = '';
				$leFichierMsg = $jl_diarama_plugin_chemin.'/jl_b2diarama_msg_'.$diarama_lang.'.js';
				if(file_exists($leFichierMsg))
				{
					//$lesMsg = file_get_contents($leFichierMsg);
					$lesMsg = '<script type="text/javascript" src="../../plugins/b2slideshow_plugin/jl_b2diarama_msg_'.$diarama_lang.'.js"></script>';
				}
				else
				{
					$leFichierMsg = $jl_diarama_plugin_chemin.'/jl_b2diarama_msg_en.js';	
					if(file_exists($leFichierMsg))
					{
						$lesMsg = '<script type="text/javascript" src="../../plugins/b2slideshow_plugin/jl_b2diarama_msg_en.js"></script>';
						//$lesMsg = file_get_contents($leFichierMsg);
					}
					else
					{
						$lesMsg = '
<script type="text/javascript">
// service messages
var jl95870cam_msg_0="This was the first image !";
var jl95870cam_msg_1="This was the last image !";
var jl95870cam_msg_2="Three reading errors in a row...\nStop the automatic display ?";
var jl95870cam_msg_3="";
var jl95870cam_msg_4="Automatic display of the images\nat a speed of 1 / xx second"; // garder xx !
var jl95870cam_msg_5="Automatic display stopped.";
// text of the help bolloons displayed when the mouse cursor is over a button
var jl95870cam_title=new Array();
jl95870cam_title[0]="Slideshow (delay:";
jl95870cam_title[1]="Display the first image (this stops the automatic display).";
jl95870cam_title[2]="Display the previous image (this stops the automatic display).";
jl95870cam_title[3]="Stop the automatic display.";
jl95870cam_title[10]="Start the automatic display.";
jl95870cam_title[4]="Display the next image (this stops the automatic display).";
jl95870cam_title[5]="Automatic display with speed selection.";
jl95870cam_title[6]="Display the last image (this stops the automatic display).";
jl95870cam_title[7]="Larger";
jl95870cam_title[8]="Smaller";
jl95870cam_title[9]="Display the help window";
// text of the help window (it may be modified)
var jl95870cam_texteAide="<br />When starting, the image change speed is every <span id=\"jl95870cam_affIntervalle\">15</span> sec";
jl95870cam_texteAide+="<br />but you can go to the next with a click on";
jl95870cam_texteAide+="<br />the photo or make some settings with the nav";
jl95870cam_texteAide+="<br />bar which is hiddien at the top of each photo.";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br />To copy an image, stop the automatic display [o]";
jl95870cam_texteAide+="<br /> and then use your mouse right button...";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br />To clear this help window : click here !";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br /><small>&copy;Jacques Louvel 2010-2012</small>";
jl95870cam_texteAide+="<br />&nbsp;";
//
var jl95870cam_texteOk=true; //  // to test loading is completed - do not change !
</script>
';
					};
					$annonce = 'The requested language file was not found.\nThe interface will be displayed in english.\nYou may create a language file using the\nprovided english or french template in the\nplugins/jl_b2diarama_plugin directory.';
				};
			};
			// part to be included by the plugin
			$jl_diarama_page = '
<style type="text/css">
#jl95870cam_lapage {position:relative;text-align:center;top:0px;margin:0px;margin-top:5px;padding:0px;border:0px;overflow:auto;} /* background-color:#555; */
#jl95870cam_commandes {position:relative;min-height:24px;top:0px;margin:0px;margin-bottom:-25px;padding:0px;text-align:center;line-height:15px;font-weight:bold;color:white;filter:alpha(opacity=30); opacity:0.30;z-index:5;}
#jl95870cam_commandes:hover{filter:alpha(opacity=100); opacity:1.0;}
#jl95870cam_titre{width:16em;margin-left:auto;margin-right:auto;background-color:black;}
#jl95870cam_conteneurImg {position:relative;top:0px;width:620px;min-height:50px;margin-left:auto;margin-right:auto;z-index:1;}
#jl95870cam_imgVisible {border:0px;width:620px;min-height:50px;display:none;margin-left:auto;margin-right:auto;z-index:1;}
#jl95870cam_imgTest {border:0px;width:1px;height:1px;display:none;}
#jl95870cam_aide {position:relative;top:0px;width:400px;height:270px;border:2px solid red;margin-top:20px;margin-left:auto;margin-right:auto;font-weight:bold;background-color:gray;filter:alpha(opacity=75); opacity:0.75;color:black;z-index:10;display:none;}
.jl95870cam_bouton1 {display:inline;width:22px;height:22px;line-height:24px;margin:0px;margin-bottom:2px;padding-left:2px;padding-right:2px;text-align:center;vertical-align:middle;font-weight:bold;background-color:gray;border-top: 1px solid white;border-left: 1px solid white;border-bottom: 1px solid gray;border-right: 1px solid gray;/*background:url(cam/bouton-noir-2.png) no-repeat;*/color:white;text-decoration:none;}
.jl95870cam_bouton1:hover {border-top: 1px solid gray;border-left: 1px solid gray;border-bottom: 1px solid white;border-right: 1px solid white;color:yellow;/*background:url(cam/bouton-noir.png) no-repeat;*/}
.jl95870cam_boutonV {display:inline;width:90px;height:22px;line-height:24px;margin:0px;margin-bottom:2px;padding-left:2px;padding-right:2px;text-align:center;vertical-align:middle;background-color:gray;border-top: 1px solid white;border-bottom: 1px solid gray;/*background:url(cam/bouton-noir-2.png) no-repeat;*/text-decoration:none;}
.jl95870cam_boutonR {font-weight:bold;text-decoration:none;color:red;cursor:pointer;}
.jl95870cam_boutonR:hover {text-decoration:underline;color:white;}
</style>

<script type="text/javascript">
<!--
/**
 * Variables adaptables permettant la personnalisation 
 * des paramtres et du fonctionnement de la page
 *
 * You may adapt these variables to your need
 */
var jl95870cam_dirImage="'.$diarama_leDir.'"; // dossier o sont stockes les images
//
var jl95870cam_lang="'.$diarama_lang.'"; // langue des titres et de l\'affichage (fr ou en)
var jl95870cam_modeImage='.$diarama_modeImage.'; // 1= nombre d\'images illimit / 0= une seule image renouvele
var jl95870cam_tailleImage='.$diarama_tailleImage.'; // taille d\'affichage de l\'image (squence 1=450;2=620;3=800;4=1024;5=autre)
var jl95870cam_rapportImage='.$diarama_rapportImage.'; // rapport largeur x hauteur des images (h = width * rapport)
var jl95870cam_forceRatio='.$diarama_forceRatio.'; // drapeau pour indiquer si on doit forcer la hauteur d\'image
var jl95870cam_intervalle='.$diarama_interval.'; // intervalle en secondes
var jl95870cam_premiere='.$diarama_premiere.'; // numro de la premire image  lire
var jl95870cam_derniere='.$diarama_derniere.'; // numro de la premire image  lire
var jl95870cam_modeAuto='.$diarama_auto.'; // mode diaporama = les images sont lues successivement avec l\'intervalle 
var jl95870cam_circulaire='.$diarama_circulaire.'; // mode diaporama = on reboucle  la fin
var jl95870cam_aideIni='.$diarama_aideIni.'; // montrer l\'aide  l\'ouverture (dfaut = 1);
var jl95870cam_prems="'.$jl95870cam_prems.'"; // chemin de la premire image
var jl95870cam_position="'.$diarama_position.'"; // diarama position 1 = in the post body (default) / 0 = at the head of the post (linked image)
//
var jl95870cam_couleurCmdSelect="white"; // modifier comme dans css / jl95870cam_boutonR
var jl95870cam_couleurCmdBase="red"; // modifier comme dans css / jl95870cam_boutonR:hover
//
var jl95870cam_imageWidth='.$diarama_width.';
var jl95870cam_annonce="'.$annonce.'";
var jl95870cam_listeImg=new Array('.$filelist.');
var jl95870cam_cmt='.$diarama_cmt.'; // nombre des commentaires non vides associs aux images (si liste)
// tableau des commentaires
'.$lesCmt.'
-->
</script>

'.$lesMsg.'

<script type="text/javascript" src="../../plugins/b2slideshow_plugin/jl_b2diarama_func.js"></script>
';
			// if the image is in head position we don not display it here
			if($diarama_position == 1)
			{
				$jl_diarama_page .= '
<div id="jl95870cam_lapage">
<div id="jl95870cam_commandes" onClick="jl95870cam_affAide(\'none\');" onMouseover="jl95870cam_chgeOpacite_max(this.id);" onMouseout="jl95870cam_chgeOpacite_min(this.id);">
<a id="jl95870cam_cmd1" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(-1);" title="Afficher la premire image (cela interrompt le dfilement automatique).">|&lt;</a> 
<a id="jl95870cam_cmd2" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(-2);" title="Afficher l\'image prcdente (cela interrompt le dfilement automatique).">&lt;</a> 
<a id="jl95870cam_cmd3" class="jl95870cam_bouton1" href="javascript:jl95870cam_autoV(0);" title="Arrt du dfilement automatique des images.">o</a>
<a id="jl95870cam_cmd4" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(0);" title="Afficher l\'image suivante (cela interrompt le dfilement automatique).">&gt;</a>
<a id="jl95870cam_cmd6" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(1);" title="Afficher la dernire image (cela interrompt le dfilement automatique).">&gt;|</a>
&nbsp;
<div id="jl95870cam_cmd5" class="jl95870cam_boutonV" title="Dfilement automatique avec slection de la vitesse.">
<a class="jl95870cam_boutonR" id="jl95870cam_v0" href="javascript:jl95870cam_autoV(3);" title="3 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v1" href="javascript:jl95870cam_autoV(5);" title="5 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v2" href="javascript:jl95870cam_autoV(10);" title="10 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v3" href="javascript:jl95870cam_autoV(15);" title="15 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v4" href="javascript:jl95870cam_autoV(30);" title="30 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v5" href="javascript:jl95870cam_autoV(60);" title="60 s">&gt;</a>
</div>
&nbsp;
<a id="jl95870cam_cmd7" class="jl95870cam_bouton1" href="javascript:jl95870cam_plus();" title="Plus grand">+</a>
<a id="jl95870cam_cmd8" class="jl95870cam_bouton1" href="javascript:jl95870cam_moins();" title="Plus petit">-</a>
&nbsp;
<a id="jl95870cam_cmd9" class="jl95870cam_bouton1" href="javascript:jl95870cam_affAide(\'block\');" title="Afficher l\'aide">?</a>
<div id="jl95870cam_titre"><span id="jl95870cam_afftitre">Diaporama (dlai:</span> <span id="jl95870cam_affdelai">15</span>s)</div>
</div>
<div id="jl95870cam_conteneurImg" style="width:50px;display:block;">
<img id="jl95870cam_imgVisible" src="'.$jl95870cam_prems.'" style="display:block;" onClick="jl95870cam_der(0);" />
<div id="jl95870cam_temoin" style="width:620;height:1px;display:none;"></div>
</div>
<div id="jl95870cam_aide" onClick="jl95870cam_affAide(\'none\');">
<br />Au dpart l\'image est rafrachie toutes les <span id="jl95870cam_affIntervalle">30</span> sec
<br />mais on peut passer  la suivante en cliquant
<br />sur la photo ou faire des rglages avec la barre 
<br />de navigation cache en haut de chaques photo.
<br />&nbsp;
<br />Pour copier une image arrter le dfilement auto [o]
<br />puis utiliser le bouton droit de la souris ...
<br />&nbsp;
<br />Pour effacer ce texte : cliquer ici !
<br />&nbsp;
</div>
<img id="jl95870cam_imgTest" onError="jl95870cam_erreur();" onLoad="jl95870cam_charge();" src="" />
</div>';
			};
			$jl_diarama_page .= '

<script type="text/javascript">jl95870cam_ini();</script>
';
			//
			$content = preg_replace('"'.$matches[0].'"',$jl_diarama_page,$content,1);
		};
		return true;
	}


	/**
	 * Do the same as for HTML.
	 *
	 * @see RenderItemAsHtml()
	 */
	function RenderItemAsXml( & $params )
	{
		$this->RenderItemAsHtml( $params );
	}

	/**
	 *
	 * Render comments if required
	 *
	 * @see Plugin::FilterCommentContent()
	 */
	function FilterCommentContent( & $params )
	{
		/*if( $this->Settings->get( 'render_comments' ) )
		{
			$this->RenderItemAsHtml( $params ) ;
		}*/
	}
}
?>
