<?php 
/* JL_B2Diarama = Slide show in B2evolution
** This program is intended to be used as a plugin in a Photoblog in B2evolution (tested in v4)
** It was written starting from a full HTML version developped for personnal use (ask the
** author if you are interested). It was adapted to be easily used in a Photoblog (or else, 
** providing an adaptation of the images width). This script / page is supposed to be run in an 
** iframe. (this is the working solution that the author found although he knows that some 
** people dislike iframes :). Tested with : MSIE8, MSIE9, FF15, Opera 9, GoogleChrome
**
** HOW TO USE IT
** 1/ copy the plugin b2slideshow_plugin as usual in B2evo (your-blog/plugins)
** __ then install it through the back-office Main-Settings/Plugins
** 2/ in your post simply insert a code {{fr:15:620:Photoblog/subDir}} where ...
** __ fr = language code. Possible values : fr or en (to be extended by yourself)
** __ 15 = interval between images. Possible values : 1-99 or 0 for a static fiirst image
** __ 620 = width of the displayed image (2 standard values : 620 and 450 optimized
** __ respectively for photoblog and blogs with a side bar; values 100-999 are allowed).
** __ Photobog = the name of your photoblog sub-directory in media/blogs/ directory
** __ subDir = the name of the sub-sub-directory if any (recommended) in Photoblog
** 3/ text or comment may be added before or after this code
** 4/ save
** 5/ RESULT : each image (jpeg, png, gif or tiff) present in the directory will be shown
**  in an iframe in the post during the requested time interval. Try it !
** 
** Copyright (c)  Jacques Louvel <jacques@le-fataliste.fr> 2012
** Note: the Wikipedia Links plugin was used as a template for the rendering
*/
$refer = '';
if (isset($_SERVER['HTTP_REFERER'])) 
{
	// check the calling url
	$uri = parse_url($_SERVER['HTTP_REFERER']);
	$refer = $uri['host'];
};
if($refer != $_SERVER['HTTP_HOST'])
{
	// the call was not made from our domain
	// => we go to my help page.
	header('Location: http://www.le-fataliste.fr/blabla/atelier/jl-diarama');
	exit();
};
//
//
$diarama_aideIni = 0; // 0 ou 1 = affichage de l'aide au dmarrage avec suspension du timer
$diarama_rapportImage = 0.675; // ratio width/height de l'image = 4/3
$diarama_forceRatio = 0;
$diarama_modeImage = 1; // mode Image => 0=une seule image renouvele / 1=nombre d'images indtermin
$diarama_circulaire = 0; // mode Diarama => 0=on s'arrte  la dernire image  / 1=on reboucle au dbut n=c fois
$diarama_premiere = 0; // premire Image 
$diarama_derniere = -1; // dernire Image : -1= pas encore dfinie
$diarama_ordre = 2; // 2 = on ne change pas l'ordre lu  / 0=hasard / 1=ordre alpha / -1=inverse / -2=alpha inverse
$diarama_liste = ''; // liste des fichiers images
$diarama_cmt = 0; // nombre de commentaires associs aux fichiers images
$lesMsg = '';
$lesCmt = '';
$onYva = false;
//
$diarama_lang = 'fr';
if(isset($_GET['lang']))
{
	// we get the language parameter
	$diarama_lang = strtolower(trim(@$_GET['lang']));
	if( ($diarama_lang == '') OR (strlen($diarama_lang) > 3) ){$diarama_lang = 'en';};
};
//
$diarama_interval = 10;
$diarama_auto = 1;
if(isset($_GET['s']))
{
	// we get the speed parameter (i.e. the slide interval)
	$diarama_interval = intval($_GET['s']);
	if($diarama_interval == 0){$diarama_auto = 0;};
};
//
$diarama_width = 620;
if(isset($_GET['w']))
{
	$diarama_width = intval($_GET['w']);
	if(in_array($diarama_width,array(450,620,800,1024)))
	{
		$diarama_tailleImage = array_search($diarama_width,array(1 => 450, 2 => 620, 3 => 800, 4 => 1024));
	}
	else
	{
		$diarama_tailleImage = 5;
	};
};
//
if(isset($_GET['h']))
{
	// on affichera l'aide au dmarrage si 1 (avec suspension du timer)
	$diarama_aideIni = trim($_GET['h']);
	if( $diarama_aideIni != 0) 
	{
		$diarama_aideIni = 1;
	};
};
//
if(isset($_GET['f']))
{
	// on prcise les extensions permises
	$diarama_fileTypes = trim($_GET['f']);
	$temp_fileTypes = explode(",",$diarama_fileTypes);
	for($i=0;$i<count($temp_fileTypes);$i++)
	{
		if(in_array($temp_fileTypes[$i],array('jpg','jpeg','png','gif','tif','tiff')))
		{
			$t_fileTypes[] = $temp_fileTypes[$i];
		};
	};
};
if(count($t_fileTypes) == 0)
{
	$t_fileTypes = array('jpg','jpeg','png','gif','tif','tiff');
};
//
if(isset($_GET['r']))
{
	// ratio width/height de l'image
	$diarama_rapportImage = floatval(trim($_GET['r']));
	$diarama_forceRatio = 1;
	if(($diarama_rapportImage<=0) OR ($diarama_rapportImage>2.5))
	{
		$diarama_rapportImage = 0.675;
		$diarama_forceRatio = 0;
	};
};
//
if(isset($_GET['m']))
{
	// mode Image => 0=une seule image renouvele / 1=nombre d'images indtermin
	$diarama_modeImage = intval(trim($_GET['m']));
	if(($diarama_modeImage != 0) AND ($diarama_modeImage != 1))
	{
		$diarama_modeImage = 1;
	};
};
//
if(isset($_GET['c']))
{
	// mode Diarama => 0=on s'arrte  la dernire image  / 1=on reboucle au dbut n=c fois
	$diarama_circulaire = intval(trim($_GET['c']));
	if( ($diarama_circulaire < 0) OR ($diarama_circulaire > 100) )
	{
		$diarama_circulaire = 1;
	};
};
//
if(isset($_GET['p']))
{
	// premire Image 
	$diarama_premiere = intval(trim($_GET['p']));
};
//
if(isset($_GET['d']))
{
	// dernire Image 
	$diarama_derniere = intval(trim($_GET['d']));
};
//
if(isset($_GET['o']))
{
	// classement alpha des noms de fichiers
	// 2= inchang / 0=hasard / 1=ordre alpha / -1=inverse / -2=alpha inverse
	$diarama_ordre = intval(trim($_GET['o']));
};
//
if(isset($_GET['l']))
{
	// liste de fichiers = fichier texte
	$diarama_liste = trim($_GET['l']);								
};
//
if(isset($_GET['id']))
{
	// we get the images path parameter
	$diarama_chemin = trim(@$_GET['id']);
	$lesDossiers = explode("/",$diarama_chemin);
	if( count($lesDossiers) == 1)
	{
		$lesDossiers[1] = trim($lesDossiers[0]);
		$lesDossiers[0] = '';
	};
	if( trim($lesDossiers[0]) == '')
	{
		$lesDossiers[0] = 'Photoblog';
	};
	if( trim($lesDossiers[1]) == '')
	{
		$lesDossiers[1] = 'diarama';
	};
	$leDossier = '';
	for($i=0;$i<count($lesDossiers);$i++)
	{
		if(trim($lesDossiers[$i]) != '')
		{
			if($leDossier != ''){ $leDossier.='/';};
			$leDossier .= $lesDossiers[$i];
		};
	};
	$diarama_leDir = '../../media/blogs/'.$leDossier;
};
//
$jl95870cam_prems = "";
$filelist = '';
$fileCpt = -1;
if($diarama_liste != '')
{
	$ext = substr(strtolower(strrchr(basename($diarama_liste), ".")), 1);
	if( $ext == 'txt' )
	{
		$diarama_laListe = $diarama_leDir.'/'.$diarama_liste;
		if(file_exists($diarama_laListe))
		{
			$filelist_tab = file($diarama_laListe, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
			$filecomt_tab = '';
			for($i = 0; $i < count($filelist_tab); $i++)
			{
				$file = trim($filelist_tab[$i]);
				// on rcupre le nom de fichier image et son commentaire ventuel (aprs un point-vrigule)
				$file_tab = explode(";",$file);
				$file = $file_tab[0];
				if(count($file_tab) > 1)
				{
					$filecomt = strip_tags(trim($file_tab[1]),'<i><u><b><font>');
				}
				else
				{
					$filecomt = '';
				};
				if(is_file($diarama_host_leDir.'/'.$file))
				{
					$ext = substr(strtolower(strrchr(basename($file), ".")), 1);
					if(in_array($ext,$t_fileTypes))
					{
						if($filelist != '')
						{ 
							$filelist .= ', ';
						}
						else
						{
							$jl95870cam_prems = $diarama_leDir.'/'.$file;
							// on ne modifiera pas l'ordre mme si le code dit le contraire
							$diarama_ordre = 2;
						};
						$filelist .= "'".$file."'";
						$filecomt_tab[] = $filecomt;
						if($filecomt != '')
						{
							$diarama_cmt ++;
						};
						$onYva = true;
						$fileCpt ++;
					};
				};
			};
		};
	};
}
else
{
	if ($dir = @opendir($diarama_leDir)) 
	{
		while (($file = readdir($dir)) !== false) 
		{
			if(is_file($diarama_leDir.'/'.$file))
			{
				$ext = substr(strtolower(strrchr(basename($file), ".")), 1);
				if(in_array($ext,$t_fileTypes))
				{
					if($filelist != '')
					{ 
						$filelist .= ', ';
					}
					else
					{
						$jl95870cam_prems = $diarama_leDir.'/'.$file;
					};
					$filelist .= "'".$file."'";
					$filecomt_tab[] = '';
					$onYva = true;
					$fileCpt ++;
				};
			};
		}; 
		closedir($dir);
	};
};
if(! $onYva) 
{
	//s'il n'y a pas d'image dans le dossier
	if($diarama_liste != '')
	{
		$annonce = 'Aucun fichier image valide dans le fichier '.$diarama_liste.'\nou ce fichier n\'existe pas dans le dossier images\n\nNo valid image file in the file '.$diarama_liste.'\nor this file was not found in the specified dir.';
		$lesMsg = 'Aucun fichier image valide dans le fichier '.$diarama_liste.'<br />ou ce fichier n\'existe pas dans le dossier images<br /><br />No valid image file in the file '.$diarama_liste.'<br />or this file was not found in the specified dir.';
	}
	else
	{
		$annonce = 'Aucun fichier image valide dans le dossier '.$diarama_leDir.'\nNo valid image file in the directory '.$diarama_leDir;
		$lesMsg = 'Aucun fichier image dans le dossier '.$diarama_leDir.'<br />No image file in the directory '.$diarama_leDir;
	};
}
else
{
	if(($diarama_premiere <= 0) OR ($diarama_premiere > $fileCpt))
	{
		$diarama_premiere = 0;
	};
	if(($diarama_derniere < $diarama_premiere) OR ($diarama_derniere > $fileCpt))
	{
		$diarama_derniere = $fileCpt;
	};
	// classement alpha des noms de fichiers
	// 2=sans changement / 0=hasard / 1=ordre alpha / -1=inverse / -2=alpha inverse
	if( ($diarama_ordre == 0) OR ($diarama_ordre == 1) OR ($diarama_ordre == -1) OR ($diarama == -2) )
	{
		$temp_fileList = explode(",",$filelist);
		if($diarama_ordre == 0)
		{
			shuffle($temp_fileList);
		};
		if( $diarama_ordre == 1 )
		{
			natcasesort($temp_fileList);
		};
		if( $diarama_ordre == -2 )
		{
			rsort($temp_fileList);
		};
		if( $diarama_ordre == -1 )
		{
			$temp_fileList = array_reverse($temp_fileList);
		};
		$filelist = '';
		$filelist = implode(',',$temp_fileList);
		/*
		for($i=0;$i<count($temp_fileList);$i++)
		{
			if($filelist != ''){ $filelist .= ', ';};
			$filelist .= $temp_fileList[$i];
		};
		*/
		$jl95870cam_prems = $diarama_leDir.'/'.$temp_fileList[0];
	};
	// cration du tableau js des commentaires (vide si pas de comt)
	$lesCmt = 'var jl95870cam_listeCmt=new Array();';
	for($i = 0;$i < count($filecomt_tab);$i++)
	{
		$lesCmt .= "\n".'jl95870cam_listeCmt['.$i.']="'.$filecomt_tab[$i].'";';
	};
	//
	$diarama_leDir .= '/';
	$annonce = '';
	$leFichierMsg = 'jl_b2diarama_msg_'.$diarama_lang.'.js';
	if(file_exists($leFichierMsg))
	{
		$lesMsg = '<script type="text/javascript" src="jl_b2diarama_msg_'.$diarama_lang.'.js"></script>';
		//$lesMsg = file_get_contents($leFichierMsg);
	}
	else
	{
		$leFichierMsg = 'jl_b2diarama_msg_en.js';	
		if(file_exists($leFichierMsg))
		{
			$lesMsg = '<script type="text/javascript" src="jl_b2diarama_msg_en.js"></script>';
			//$lesMsg = file_get_contents($leFichierMsg);
		}
		else
		{
			$lesMsg = '
<script type="text/javascript">
// service messages
var jl95870cam_msg_0="This was the first image !";
var jl95870cam_msg_1="This was the last image !";
var jl95870cam_msg_2="Three reading errors in a row...\nStop the automatic display ?";
var jl95870cam_msg_3="";
var jl95870cam_msg_4="Automatic display of the images\nat a speed of 1 / xx second"; // garder xx !
var jl95870cam_msg_5="Automatic display stopped.";
// text of the help bolloons displayed when the mouse cursor is over a button
var jl95870cam_title=new Array();
jl95870cam_title[0]="Slideshow (delay:";
jl95870cam_title[1]="Display the first image (this stops the automatic display).";
jl95870cam_title[2]="Display the previous image (this stops the automatic display).";
jl95870cam_title[3]="Stop the automatic display.";
jl95870cam_title[10]="Start the automatic display.";
jl95870cam_title[4]="Display the next image (this stops the automatic display).";
jl95870cam_title[5]="Automatic display with speed selection.";
jl95870cam_title[6]="Display the last image (this stops the automatic display).";
jl95870cam_title[7]="Larger";
jl95870cam_title[8]="Smaller";
jl95870cam_title[9]="Display the help window";
// text of the help window (it may be modified)
var jl95870cam_texteAide="<br />When starting, the image change speed is every <span id=\"jl95870cam_affIntervalle\">15</span> sec";
jl95870cam_texteAide+="<br />but you can go to the next with a click on";
jl95870cam_texteAide+="<br />the photo or make some settings with the nav";
jl95870cam_texteAide+="<br />bar which is hiddien at the top of each photo.";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br />To copy an image, stop the automatic display [o]";
jl95870cam_texteAide+="<br /> and then use your mouse right button...";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br />To clear this help window : click here !";
jl95870cam_texteAide+="<br />";
jl95870cam_texteAide+="<br /><small>&copy;Jacques Louvel 2010-2012</small>";
jl95870cam_texteAide+="<br />&nbsp;";
//
var jl95870cam_texteOk=true; //  // to test loading is completed - do not change !
</script>
';
		};
		$annonce = 'The requested language file was not found.\nThe interface will be displayed in english.\nYou may create a language file using the\nprovided english or french template in the\nplugins/jl_b2diarama_plugin directory.';
	};
};
?>
<html>
<head>
<meta http-equiv="Content-Type" Content="text/html; charset=ISO-8859-1">
<meta name="robots" content="noindex,nofollow,noarchive"
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="0">
<meta name="author" lang="fr" content="Jacques LOUVEL"> 
<meta name="publisher" content="Jacques Louvel">
<meta name="copyright" content="Jacques Louvel - 2010-2012">
<!--
/* **************************************** */
/* Ne pas supprimer les meta author et copyright SVP */
/* Please do not remove the meta author & copyright */
/* **************************************** */
-->
<style type="text/css">
body {background-color:#555;margin:0px;padding:0px;border-width:0px;border-color:#555;} /* si mode page entire */
#jl95870cam_lapage {position:relative;text-align:center;top:0px;margin:0px;margin-top:5px;padding:0px;border:0px;overflow:auto;background-color:#555;}
#jl95870cam_commandes {position:relative;min-height:24px;top:0px;margin:0px;margin-bottom:-25px;padding:0px;text-align:center;line-height:15px;font-weight:bold;color:white;filter:alpha(opacity=30); opacity:0.30;z-index:5;}
#jl95870cam_commandes:hover{filter:alpha(opacity=100); opacity:1.0;}
#jl95870cam_titre{width:16em;margin-left:auto;margin-right:auto;background-color:black;}
#jl95870cam_conteneurImg {position:relative;top:0px;width:620px;min-height:50px;margin-left:auto;margin-right:auto;z-index:1;}
#jl95870cam_imgVisible {border:0px;width:620px;min-height:50px;display:none;margin-left:auto;margin-right:auto;z-index:1;}
#jl95870cam_imgTest {border:0px;width:1px;height:1px;display:none;}
#jl95870cam_aide {position:relative;top:0px;width:400px;height:270px;border:2px solid red;margin-top:20px;margin-left:auto;margin-right:auto;font-weight:bold;background-color:gray;filter:alpha(opacity=75); opacity:0.75;color:black;z-index:10;display:none;}
.jl95870cam_bouton1 {display:inline;width:22px;height:22px;line-height:24px;margin:0px;margin-bottom:2px;padding-left:2px;padding-right:2px;text-align:center;vertical-align:middle;font-weight:bold;background-color:gray;border-top: 1px solid white;border-left: 1px solid white;border-bottom: 1px solid gray;border-right: 1px solid gray;/*background:url(cam/bouton-noir-2.png) no-repeat;*/color:white;text-decoration:none;}
.jl95870cam_bouton1:hover {border-top: 1px solid gray;border-left: 1px solid gray;border-bottom: 1px solid white;border-right: 1px solid white;color:yellow;/*background:url(cam/bouton-noir.png) no-repeat;*/}
.jl95870cam_boutonV {display:inline;width:90px;height:22px;line-height:24px;margin:0px;margin-bottom:2px;padding-left:2px;padding-right:2px;text-align:center;vertical-align:middle;background-color:gray;border-top: 1px solid white;border-bottom: 1px solid gray;/*background:url(cam/bouton-noir-2.png) no-repeat;*/text-decoration:none;}
.jl95870cam_boutonR {font-weight:bold;text-decoration:none;color:red;cursor:pointer;}
.jl95870cam_boutonR:hover {text-decoration:underline;color:white;}
</style>
<!--
/* *************************************** */
-->
<script type="text/javascript">
<!--
/**
 * Variables adaptables permettant la personnalisation 
 * des paramtres et du fonctionnement de la page
 *
 * You may adapt these variables to your need
 */
var jl95870cam_dirImage="<?php echo $diarama_leDir; ?>"; // dossier o sont stockes les images
//
var jl95870cam_lang="<?php echo $diarama_lang; ?>"; // langue des titres et de l'affichage (fr ou en)
var jl95870cam_modeImage=<?php echo $diarama_modeImage; ?>; // 1= nombre d'images illimit / 0= une seule image renouvele
var jl95870cam_tailleImage=<?php echo $diarama_tailleImage; ?>; // taille d'affichage de l'image (squence 1=450;2=620;3=800;4=1024;5=autre)
var jl95870cam_rapportImage=<?php echo $diarama_rapportImage; ?>; // rapport largeur x hauteur des images (h = width * rapport)
var jl95870cam_forceRatio=<?php echo $diarama_forceRatio; ?>; // drapeau pour indiquer si on doit forcer la hauteur d'image
var jl95870cam_intervalle=<?php echo $diarama_interval; ?>; // intervalle en secondes
var jl95870cam_premiere=<?php echo $diarama_premiere; ?>; // numro de la premire image  lire
var jl95870cam_derniere=<?php echo $diarama_derniere; ?>; // numro de la dernire image  lire
var jl95870cam_modeAuto=<?php echo $diarama_auto; ?>; // mode diaporama = les images sont lues successivement avec l'intervalle 
var jl95870cam_circulaire=<?php echo $diarama_circulaire; ?>; // mode diaporama = on reboucle  la fin
var jl95870cam_aideIni=<?php echo $diarama_aideIni; ?>; // montrer l\'aide  l\'ouverture (dfaut = 1);
var jl95870cam_prems="<?php echo $jl95870cam_prems; ?>"; // chemin de la premire image
//
var jl95870cam_couleurCmdSelect="white"; // modifier comme dans css / jl95870cam_boutonR
var jl95870cam_couleurCmdBase="red"; // modifier comme dans css / jl95870cam_boutonR:hover
//
var jl95870cam_imageWidth=<?php echo $diarama_width; ?>;
var jl95870cam_annonce="<?php echo $annonce; ?>";
var jl95870cam_listeImg=new Array(<?php echo $filelist; ?>);
var jl95870cam_cmt=<?php echo $diarama_cmt; ?>; // nombre des commentaires non vides associs aux images (si liste)
// tableau des commentaires
<?php echo $lesCmt; ?>

-->
</script>

<?php echo $lesMsg; ?>

<script type="text/javascript">
// correspond  jl_b2diarama_func.js de la version 2
var jl95870cam_intervalleMemo=jl95870cam_intervalle;
var jl95870cam_delai=jl95870cam_intervalle*1000; // intervalle de rafrachissement des images
var jl95870cam_im=jl95870cam_premiere; // image en cours
var jl95870cam_auto=jl95870cam_modeAuto; // on est en modeAuto
var jl95870cam_t; // variable pour le timer
//
var jl95870cam_nbscr;
var jl95870cam_timerid;
var jl95870cam_timeout;
var jl95870cam_cpterr;
var jl95870cam_cpterr2;
var jl95870cam_numim;
var jl95870cam_iniOk=0;
var jl95870cam_hfixe=0;
var jl95870cam_opacite=100;
var jl95870cam_modeAuto_mem;
// definition d'une image de 1px en XBM en javascript
// pour constituer une source valide des img au dmarrage
var jl95870cam_imgXBM = "";
jl95870cam_imgXBM+='#define image_width 1\n';
jl95870cam_imgXBM+='#define image_height 1\n';
jl95870cam_imgXBM+='static char image_bits[] = { 0x00 };';
//
function jl95870cam_erreur(){
  if(jl95870cam_iniOk==0){return false;};
  // fonction appele par le onError lors de l'chec
  // du chargement de l'image de test cache.
  if(jl95870cam_auto==0){alert(jl95870cam_msg_1);};
  //jl95870cam_auto=1;
  if(jl95870cam_cpterr==undefined){jl95870cam_cpterr=0;};
  if(jl95870cam_cpterr2==undefined){jl95870cam_cpterr2=0;};
  if(jl95870cam_numim==undefined){jl95870cam_numim=jl95870cam_im;};
  if(jl95870cam_numim==jl95870cam_im){
    jl95870cam_cpterr++;
    if(jl95870cam_cpterr>=2){
      if(jl95870cam_cpterr2==1){
	if(confirm(jl95870cam_msg_2)){
		jl95870cam_cpterr=0;
		jl95870cam_cpterr2=0;
		jl95870cam_modeAuto=0;
		jl95870cam_auto=0;
	};
      }
      else
      {
	jl95870cam_cpterr2++;
	jl95870cam_im=jl95870cam_premiere;
      };
    };
  }
  else {
    jl95870cam_cpterr=1;
    jl95870cam_numim=jl95870cam_im;
  };
  jl95870cam_im=jl95870cam_im-1;
  if(jl95870cam_im<jl95870cam_premiere){jl95870cam_im=jl95870cam_premiere;};
  jl95870cam_nouvelleImage();
}
//
function jl95870cam_nouvelleImage(){
  if(jl95870cam_t){clearTimeout(jl95870cam_t);};
  jl95870cam_precharge(); // on teste l'image avant de l'ouvrir
  if(jl95870cam_modeAuto==1){jl95870cam_t=setTimeout("jl95870cam_nouvelleImage();", jl95870cam_delai);};
}
//
function jl95870cam_precharge(){
  // on tente de charger l'image dans l'img cache
  var forceRelecture="";
  if(jl95870cam_modeImage==0){
    var cejour=new Date(); // pour forcer la relecture si on est en mode une seule image
    forceRelecture="?"+cejour.getTime();
  };
  var inImg=jl95870cam_dirImage+jl95870cam_listeImg[jl95870cam_im]+forceRelecture;
  document.getElementById('jl95870cam_imgTest').src=inImg;
  return;
}
//
function jl95870cam_charge(){
  // chargement de l'image teste dans l'img visible
  // fonction appele par onLoad de l'img cache (precharge)
  document.getElementById('jl95870cam_imgVisible').src=jl95870cam_dirImage+jl95870cam_listeImg[jl95870cam_im];
  if(jl95870cam_cmt>0)
  {
	document.getElementById("jl95870cam_temoin").innerHTML=jl95870cam_listeCmt[jl95870cam_im];
  };
  resizeIframeV();
  if(jl95870cam_modeImage==1)
  {
	if(jl95870cam_im>=jl95870cam_derniere)
	{
		if(jl95870cam_circulaire>0)
		{
			// si on tait  la dernire image, on boucle si demand
			jl95870cam_im=jl95870cam_premiere;
			jl95870cam_circulaire--;
		}
		else
		{
			// sinon on arrte
			jl95870cam_der(0);
		};
	}
	else
	{
		jl95870cam_im++;
	};
  };
}
//
function resizeIframeHV() {
    var lapage = document.getElementById("jl95870cam_lapage");
    var iframe = window.parent.document.getElementById("jlDiarama");
    var image = document.getElementById("jl95870cam_imgVisible");
    if(image.offsetHeight)
   {
	lapage.style.height = (image.offsetHeight+25) + "px";
	lapage.style.width = (image.offsetWidth+6) + "px";
	iframe.style.height = (image.offsetHeight+27) + "px";
	iframe.style.width = (image.offsetWidth+6) + "px";
   }
   else if(image.style.pixelHeight)
   {
	lapage.style.height = (image.style.pixelHeight+25) + "px";
	lapage.style.width = (image.style.pixelWidth+6) + "px";
	iframe.style.height = (image.style.pixelHeight+27) + "px";
	iframe.style.width = (image.style.pixelWidth+6) + "px";
   };
}
//
function resizeIframeV() {
    var lapage = document.getElementById("jl95870cam_lapage");
    var iframe = window.parent.document.getElementById("jlDiarama");
    var image = document.getElementById("jl95870cam_imgVisible");
    if(image.offsetHeight)
   {
	lapage.style.height = (image.offsetHeight+25) + "px";
	iframe.style.height = (image.offsetHeight+27) + "px";
   }
   else if(image.style.pixelHeight)
   {
	lapage.style.height = (image.style.pixelHeight+25) + "px";
	iframe.style.height = (image.style.pixelHeight+27) + "px";
   };
}
//
function jl95870cam_der(nb){
  // fonction appele onClick des icones de navigation |<, <, >
  // la direction du dplacement dans la srie est passe en param
  if(jl95870cam_modeImage==1){
    if(nb==-1){jl95870cam_im=jl95870cam_premiere+1;}; // premire image
    if(nb==1){jl95870cam_im=0;nb=jl95870cam_derniere;}; // dernire image
    jl95870cam_im=jl95870cam_im+nb;
    if(jl95870cam_im<jl95870cam_premiere){jl95870cam_im=jl95870cam_premiere;alert(jl95870cam_msg_0);};
  };
  if(jl95870cam_auto==1){
    jl95870cam_auto=0;
    jl95870cam_modeAuto=0;
    temp=jl95870cam_intervalle;
    jl95870cam_intervalle=0;
    jl95870cam_chgeVitesse();
    jl95870cam_intervalle=temp;
    document.getElementById('jl95870cam_cmd3').title=jl95870cam_title[10];
    document.getElementById('jl95870cam_cmd3').style.color=jl95870cam_couleurCmdSelect;
  };
  jl95870cam_nouvelleImage();
}
//
function jl95870cam_plus(){
  // on augmente la taille de l'image (tailles prdfinies)
  jl95870cam_tailleImage++;
  if(jl95870cam_tailleImage>5){jl95870cam_tailleImage=5;};
  switch(jl95870cam_tailleImage){
    case 1: w="450px";hh=parseInt(450*jl95870cam_rapportImage);h=""+hh+"px";ww=490;wh=Math.abs(hh)+140;break;
    case 2: w="620px";hh=parseInt(620*jl95870cam_rapportImage);h=""+hh+"px";ww=660;wh=Math.abs(hh)+140;break;
    case 3: w="800px";hh=parseInt(800*jl95870cam_rapportImage);h=""+hh+"px";ww=840;wh=Math.abs(hh)+140;break;
    case 4: w="1024px";hh=parseInt(1024*jl95870cam_rapportImage);h=""+hh+"px";ww=1064;wh=Math.abs(hh)+140;break;
    case 5: w=jl95870cam_imageWidth+"px";hh=parseInt(jl95870cam_imageWidth*jl95870cam_rapportImage);h=""+hh+"px";ww=jl95870cam_imageWidth+40;wh=Math.abs(hh)+140;break;
  };
  jl95870cam_chgeTaille(w,h,ww,wh);
}
//
function jl95870cam_moins(){
  // on diminue la taille de l'image (tailles prdfinies)
  jl95870cam_tailleImage--;
  if(jl95870cam_tailleImage<1){jl95870cam_tailleImage=1;};
  switch(jl95870cam_tailleImage){
    case 1: w="450px";hh=parseInt(450*jl95870cam_rapportImage);h=""+hh+"px";ww=490;wh=Math.abs(hh)+140;break;
    case 2: w="620px";hh=parseInt(620*jl95870cam_rapportImage);h=""+hh+"px";ww=660;wh=Math.abs(hh)+140;break;
    case 3: w="800px";hh=parseInt(800*jl95870cam_rapportImage);h=""+hh+"px";ww=840;wh=Math.abs(hh)+140;break;
    case 4: w="1024px";hh=parseInt(1024*jl95870cam_rapportImage);h=""+hh+"px";ww=1064;wh=Math.abs(hh)+140;break;
    case 5: w=jl95870cam_imageWidth+"px";hh=parseInt(jl95870cam_imageWidth*jl95870cam_rapportImage);h=""+hh+"px";ww=jl95870cam_imageWidth+40;wh=Math.abs(hh)+140;break;
  };
  jl95870cam_chgeTaille(w,h,ww,wh);
}
//
function jl95870cam_chgeTaille(w,h,ww,wh){
  // le changement de taille est effectu
  if(jl95870cam_hfixe==0){
	  // calcul de la hauteur f(ratio)
	  var jl95870cam_hbase=parseInt(jl95870cam_imageWidth*jl95870cam_rapportImage);
	  // ajout d'une marge pour l\'overfllow auto
	  jl95870cam_hfixe=jl95870cam_hbase+parseInt(jl95870cam_hbase/8.5)+"px"; 
  };
  document.getElementById("jl95870cam_lapage").style.width=jl95870cam_imageWidth+"px";
  document.getElementById("jl95870cam_lapage").style.height=jl95870cam_hfixe;
  document.getElementById('jl95870cam_conteneurImg').style.width=w;
  document.getElementById('jl95870cam_imgVisible').style.width=w;
  if(jl95870cam_forceRatio==1)
  {
	document.getElementById("jl95870cam_lapage").style.height=jl95870cam_hfixe;
	document.getElementById('jl95870cam_conteneurImg').style.height=h;
	document.getElementById('jl95870cam_imgVisible').style.height=h;
  };
  document.getElementById('jl95870cam_aide').style.top='-'+h;
  resizeIframeHV();
 }
//
function jl95870cam_autoV(v){
  // demande de modification de la vitesse du changement auto d'image
  if(jl95870cam_t){clearTimeout(jl95870cam_t);};
  if((v==0)&&(jl95870cam_modeAuto!=0)){
    alert(jl95870cam_msg_5);
    document.getElementById('jl95870cam_cmd3').title=jl95870cam_title[10];
    document.getElementById('jl95870cam_cmd3').style.color=jl95870cam_couleurCmdSelect;
    jl95870cam_modeAuto=0;
    jl95870cam_auto=0;
    jl95870cam_intervalle=0;
  }
  else
  {
    if(v==0){v=jl95870cam_intervalleMemo;};
    document.getElementById('jl95870cam_cmd3').title=jl95870cam_title[3];
    document.getElementById('jl95870cam_cmd3').style.color=jl95870cam_couleurCmdBase;
    jl95870cam_intervalle=v;
    jl95870cam_delai=v*1000;
    alert(jl95870cam_msg_4.replace('xx',jl95870cam_intervalle));
    jl95870cam_modeAuto=1;
    jl95870cam_auto=1;
    jl95870cam_t=setTimeout("jl95870cam_nouvelleImage();", jl95870cam_delai);
  };
  jl95870cam_chgeVitesse();
}
//
function jl95870cam_chgeVitesse(){
  // le changement du marqueur de vitesse est execut
  var v=-1;
  if(jl95870cam_intervalle>=60)
    v=5;
  else if(jl95870cam_intervalle>=30)
    v=4;
  else if(jl95870cam_intervalle>=15)
    v=3;
  else if(jl95870cam_intervalle>=10)
    v=2;
  else if(jl95870cam_intervalle>=5)
    v=1;
  else if(jl95870cam_intervalle>0)
    v=0;
  // changement de couleur des icones de vitesse
  for(var i=0;i<6;i++){
    var id="jl95870cam_v"+i;
    if(i==v){document.getElementById(id).style.color=jl95870cam_couleurCmdSelect;}
    else {document.getElementById(id).style.color=jl95870cam_couleurCmdBase;};
  };
}
//
function jl95870cam_affAide(onoff){
  // on montre ou on cache le petit texte d'aide
  // (visibilit en superposition avec l'image)
  if((onoff=='none')||(document.getElementById('jl95870cam_aide').style.display=='block')){
    document.getElementById('jl95870cam_aide').style.display='none';
    if(jl95870cam_iniOk==0)
    {
	if(jl95870cam_modeAuto==1){jl95870cam_t=setTimeout("jl95870cam_nouvelleImage();", jl95870cam_delai);};
	jl95870cam_iniOk=1; // fin de l'initialisation
    };
  }
  else {
    document.getElementById('jl95870cam_aide').style.display='block';
  };
}
//
function jl95870cam_chgeOpacite_min(){
	jl95870cam_opacite = 30;
	jl95870cam_chgeOpacite();
}
//
function jl95870cam_chgeOpacite_max(){
	jl95870cam_opacite = 100;
	jl95870cam_chgeOpacite();
}
//
function jl95870cam_chgeOpacite(){
	document.getElementById("jl95870cam_commandes").style.filter="progid:DXImageTransform.Microsoft.Alpha(Opacity="+jl95870cam_opacite+")";
	document.getElementById("jl95870cam_commandes").style.opacity=""+(jl95870cam_opacite/100);
}
//
function jl95870cam_ini(){
	if(jl95870cam_annonce!="")
	{
		alert(jl95870cam_annonce);
	};
	jl95870cam_ini2();
}
//
function jl95870cam_ini2(){
  jl95870cam_chgeVitesse(); // affichage du marqueur de vitesse
  jl95870cam_delai=jl95870cam_intervalle*1000;
  jl95870cam_auto=jl95870cam_modeAuto;
  //
  // remplacement des title (cas d'une traduction)
  for(var i=1;i<jl95870cam_title.length;i++){
    var idTitle='jl95870cam_cmd'+i;
    if(jl95870cam_title[i]!=''){
	if(document.getElementById(idTitle)){
		document.getElementById(idTitle).title=jl95870cam_title[i];
	};
    };
  };
  if(jl95870cam_intervalle==0)
  {
	document.getElementById('jl95870cam_cmd3').title=jl95870cam_title[10];
	document.getElementById('jl95870cam_cmd3').style.color=jl95870cam_couleurCmdSelect;
	jl95870cam_intervalle=10;
	jl95870cam_intervalleMemo=10;
  }
  else
  {
	document.getElementById('jl95870cam_cmd3').style.color=jl95870cam_couleurCmdBase;
  };
  //
  document.getElementById('jl95870cam_aide').innerHTML=jl95870cam_texteAide;
  document.getElementById('jl95870cam_affIntervalle').innerHTML=jl95870cam_intervalle;
  //
  // si la taille image est libre, on cache les boutons de redimensionnement
  if(jl95870cam_tailleImage == 5)
  {
	document.getElementById('jl95870cam_cmd7').style.display='none';
	document.getElementById('jl95870cam_cmd8').style.display='none';	
  };
  // si la taille image est infrieure  404px on cache le bouton d'aide
  if(jl95870cam_imageWidth < 404)
  {
	document.getElementById('jl95870cam_cmd9').style.display='none';
  };
  // si la taille image est infrieure  260px, on cache une partie de la barre de commande
  if(jl95870cam_imageWidth < 260)
  {
	document.getElementById('jl95870cam_cmd5').style.display='none';
	document.getElementById('jl95870cam_cmd7').style.display='none';
	document.getElementById('jl95870cam_cmd8').style.display='none';
  };
  jl95870cam_tailleImage--;
  jl95870cam_plus();
  jl95870cam_im--;
  if(jl95870cam_im<jl95870cam_premiere){jl95870cam_im=jl95870cam_premiere;};
  jl95870cam_modeAuto_mem=jl95870cam_modeAuto; // on mmorise le mode
  jl95870cam_modeAuto=0; // on passe en mode single pour ne pas activer le timer
  jl95870cam_nouvelleImage(); // sans activer le timer
  jl95870cam_modeAuto=jl95870cam_modeAuto_mem; // on rtablit le mode
  document.getElementById("jl95870cam_imgVisible").style.display="block";
  if(jl95870cam_cmt>0)
  {
	document.getElementById("jl95870cam_temoin").style.display="block;";
  };
  if(jl95870cam_aideIni==1)
  {
	document.getElementById("jl95870cam_titre").style.display="none";
	jl95870cam_affAide("block"); // affichage de l'aide sur la 1re image
  }
  else
  {
	document.getElementById("jl95870cam_afftitre").innerHTML=jl95870cam_title[0];
	document.getElementById("jl95870cam_affdelai").innerHTML=jl95870cam_intervalle;
	document.getElementById("jl95870cam_commandes").style.marginBottom="-40px";
	jl95870cam_opacite=100;
	document.getElementById("jl95870cam_commandes").style.filter='progid:DXImageTransform.Microsoft.Alpha(Opacity=100)';
	document.getElementById("jl95870cam_commandes").style.opacity=1.0;
	jl95870cam_t2=setTimeout("jl95870cam_ini3();", 2000);
  };
  // l'indication iniOk sera faite aprs effacement de l'aide
}
//
function jl95870cam_ini3(){
	document.getElementById("jl95870cam_commandes").style.filter='progid:DXImageTransform.Microsoft.Alpha(Opacity='+jl95870cam_opacite+')';
	document.getElementById("jl95870cam_commandes").style.opacity=""+(jl95870cam_opacite/100);
	if(jl95870cam_opacite>30)
	{
		jl95870cam_opacite-=2;
		jl95870cam_t2=setTimeout("jl95870cam_ini3();", 150);
	}
	else
	{
		document.getElementById("jl95870cam_titre").style.display="none";
		document.getElementById("jl95870cam_commandes").style.marginBottom="-25px";
		if(jl95870cam_modeAuto==1){jl95870cam_t=setTimeout("jl95870cam_nouvelleImage();", jl95870cam_delai);};
		jl95870cam_iniOk=1; // fin de l'initialisation
	};
}
//-->
</script>
</head>
<body onload="jl95870cam_ini();">
<div id="jl95870cam_lapage">
<div id="jl95870cam_commandes" onClick="jl95870cam_affAide('none');" onMouseover="this.style.filter='progid:DXImageTransform.Microsoft.Alpha(Opacity=100)';this.style.opacity=1.0;" onMouseout="this.style.filter='progid:DXImageTransform.Microsoft.Alpha(Opacity=30)';this.style.opacity=0.3;">
<a id="jl95870cam_cmd1" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(-1);" title="Afficher la premire image (cela interrompt le dfilement automatique).">|&lt;</a> 
<a id="jl95870cam_cmd2" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(-2);" title="Afficher l'image prcdente (cela interrompt le dfilement automatique).">&lt;</a> 
<a id="jl95870cam_cmd3" class="jl95870cam_bouton1" href="javascript:jl95870cam_autoV(0);" title="Arrt du dfilement automatique des images.">o</a>
<a id="jl95870cam_cmd4" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(0);" title="Afficher l'image suivante (cela interrompt le dfilement automatique).">&gt;</a>
<a id="jl95870cam_cmd6" class="jl95870cam_bouton1" href="javascript:jl95870cam_der(1);" title="Afficher la dernire image (cela interrompt le dfilement automatique).">&gt;|</a>
&nbsp;
<div id="jl95870cam_cmd5" class="jl95870cam_boutonV" title="Dfilement automatique avec slection de la vitesse.">
<a class="jl95870cam_boutonR" id="jl95870cam_v0" href="javascript:jl95870cam_autoV(3);" title="3 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v1" href="javascript:jl95870cam_autoV(5);" title="5 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v2" href="javascript:jl95870cam_autoV(10);" title="10 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v3" href="javascript:jl95870cam_autoV(15);" title="15 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v4" href="javascript:jl95870cam_autoV(30);" title="30 s">&gt;</a>
<a class="jl95870cam_boutonR" id="jl95870cam_v5" href="javascript:jl95870cam_autoV(60);" title="60 s">&gt;</a>
</div>
&nbsp;
<a id="jl95870cam_cmd7" class="jl95870cam_bouton1" href="javascript:jl95870cam_plus();" title="Plus grand">+</a>
<a id="jl95870cam_cmd8" class="jl95870cam_bouton1" href="javascript:jl95870cam_moins();" title="Plus petit">-</a>
&nbsp;
<a id="jl95870cam_cmd9" class="jl95870cam_bouton1" href="javascript:jl95870cam_affAide('block');" title="Afficher l'aide">?</a>
<div id="jl95870cam_titre"><span id="jl95870cam_afftitre">Diaporama (dlai:</span> <span id="jl95870cam_affdelai">15</span>s)</div>
</div>
<div id="jl95870cam_conteneurImg" style="display:block;">
<img id="jl95870cam_imgVisible" src="<?php echo $jl95870cam_prems; ?>" style="display:block;" onClick="jl95870cam_der(0);" />
</div>
<div id="jl95870cam_temoin" style="width:620;height:1px;display:none;"></div>
<div id="jl95870cam_aide" onClick="jl95870cam_affAide('none');">
<br />Au dpart l'image est rafrachie toutes les <span id="jl95870cam_affIntervalle">30</span> sec
<br />mais on peut passer  la suivante en cliquant
<br />sur la photo ou faire des rglages avec la barre 
<br />de navigation cache en haut de chaques photo.
<br />&nbsp;
<br />Pour copier une image arrter le dfilement auto [o]
<br />puis utiliser le bouton droit de la souris ...
<br />&nbsp;
<br />Pour effacer ce texte : cliquer ici !
<br />&nbsp;
</div>
<img id="jl95870cam_imgTest" onError="jl95870cam_erreur();" onLoad="jl95870cam_charge();" src="<?php echo $jl95870cam_prems; ?>" />
</div>
</body>
</html>
