<?php
/* vi: ts=2 sw=2 et nu
 * This file implements b2Diarama plugin for b2evolution
 *
 * b2Diarama allows sequential display (slide show) of 
 * the image content of a subdirectory in the media/blogs directory
 *
 * b2evolution - {@link http://b2evolution.net/}
 * Released under GNU GPL License - {@link http://b2evolution.net/about/license.html}
 * @copyright (c)2003-2007 by Francois PLANQUE - {@link http://fplanque.net/}
 * 2012 Jacques LOUVEL (jl95870)
 * 
 * @package plugins
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );


/**
 * @package plugins
 */
class b2diarama_plugin extends Plugin
{
	var $code = 'b2Diarama';
	var $name ;
	var $priority = 14;
	var $version = '1.2';
	var $apply_rendering = 'opt-out';
	var $group = 'rendering';
	var $short_desc;
	var $long_desc;
	var $number_of_installs = 1;
	var $help_url = 'http://www.le-fataliste.fr/blabla/atelier/jl-diarama';

	/*
	 * Internal
	 */
	var $post_search_list;
	var $post_replace_list;
	var $comment_search_list;
	var $comment_replace_list;

	/**
	 * Init
	 */
	function PluginInit( & $params )
	{
		$this->name = $this->T_('Diarama Links') ;
		$this->short_desc = $this->T_('Slide show Links e-g en:15:620:Photoblog/subDir');
		$this->long_desc = $this->T_('Creates html (with iframe) to display images found in the given subDir, in the specified Photoblog directory');
	}

	/**
	 * Get the default settings of the plugin.
	 *
	 * @return array
	 */
	function GetDefaultSettings()
	{
		return array( /*'render_comments' => array(
		'label' => $this->T_('Render comments'),
		'note' => $this->T_( 'If enabled, links will be produced in comments also' ),
		'defaultvalue' => 0, 
		'type' => 'checkbox'
		) */) ;
	}

	/**
	 * Perform rendering
	 *
	 * @see Plugin::RenderItemAsHtml()
	 */
	function RenderItemAsHtml( & $params )
	{
		$content = & $params['data'];
		$search  = array(
			// {{xx:Phrase}}:
			//'#\{\{([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([^\|\]]+)/([^\|\]]+)\}\}#i',
			'#([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([0-9A-Za-z]+)/([0-9A-Za-z_;\&\=\/\-]+)#i',
			// [[xx:Phrase|Text]]:
			//'#\{\{([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([^\|\]]+)\s*\|\s*([^\|\]]+)\}\}#i',
			'#([[:alpha:]]{2}):([0-9]|[0-9][0-9]):([0-9][0-9][0-9]):([0-9A-Za-z_;\&\=\/\-]+)#i',
		) ;
		$replace = array(
			'<iframe id="jlDiarama" src="../../plugins/b2diarama_plugin/jl_b2diarama.php?lang=$1&s=$2&w=$3&id=$4/$5" marginheight="0" marginwidth="0" frameborder="0" scrolling="no" style="width:100%;height:100%;overflow:hidden;"><p align="center">Les iframes ne sont pas acceptes par<br />votre navigateur ou votre configuration <br />alors que c\'est indispensable pour ce diarama.</p><p align="center">Your browser or your configuration<br /><b>does not accept iframes</b><br />while they are needed for this slide show.</p></iframe>',
			'<iframe id="jlDiarama" src="../../plugins/b2diarama_plugin/jl_b2diarama.php?lang=$1&s=$2&w=$3&id=$4" marginheight="0" marginwidth="0" frameborder="0" scrolling="no" style="width:100%;height:100%;overflow:hidden;"><p align="center">Les iframes ne sont pas acceptes par<br />votre navigateur ou votre configuration <br />alors que c\'est indispensable pour ce diarama.</p><p align="center">Your browser or your configuration<br /><b>does not accept iframes</b><br />while they are needed for this slide show.</p></iframe>',
		) ;
		$content = preg_replace( $search, $replace, $content );
		return true;
	}


	/**
	 * Do the same as for HTML.
	 *
	 * @see RenderItemAsHtml()
	 */
	function RenderItemAsXml( & $params )
	{
		$this->RenderItemAsHtml( $params );
	}

	/**
	 *
	 * Render comments if required
	 *
	 * @see Plugin::FilterCommentContent()
	 */
	function FilterCommentContent( & $params )
	{
		/*if( $this->Settings->get( 'render_comments' ) )
		{
			$this->RenderItemAsHtml( $params ) ;
		}*/
	}
}
?>
